//
//  TTTImageViewController.m
//  Tic-Tac-Toe-Storyboard
//
//  Created by Rajiv Ramnath on 11/2/13.
//  Copyright (c) 2013 Rajiv Ramnath. All rights reserved.
//

#import "TTTImageViewController.h"

@interface TTTImageViewController (){
    @private UIImage *localImage;
}

@end

@implementation TTTImageViewController

    @synthesize imageView;
    @synthesize showImageButton;
    @synthesize takeImageButton;
    @synthesize exitButton;

    - (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil{
        self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
        if (self) {
            // Custom initialization
        }
        return self;
    }

    - (void)viewDidLoad{
        [super viewDidLoad];
        // Do any additional setup after loading the view.
        NSString* imagePath =
            [[NSBundle mainBundle] pathForResource:@"Images.bundle/BookFront" ofType:@"png"];
        localImage = [[UIImage alloc] initWithContentsOfFile:imagePath];
    }

    - (void)didReceiveMemoryWarning{
        [super didReceiveMemoryWarning];
        // Dispose of any resources that can be recreated.
    }

    - (IBAction) showImage:(id)sender{
        imageView.image = localImage;
        [imageView setNeedsDisplay];
    }

    - (IBAction) takeImage:(id)sender{
        UIImagePickerController *imagePicker = [[UIImagePickerController alloc] init];
        imagePicker.sourceType = UIImagePickerControllerSourceTypeCamera;
        imagePicker.mediaTypes =   [[NSArray alloc] initWithObjects: (NSString *) kUTTypeImage, nil];

        imagePicker.delegate = self;
        [[UIApplication sharedApplication] setStatusBarHidden:YES];
        [self presentViewController:imagePicker animated:YES completion:nil];
    }

    - (void) imagePickerControllerDidCancel: (UIImagePickerController *) picker {
        [[UIApplication sharedApplication] setStatusBarHidden:NO];
        [picker dismissViewControllerAnimated:YES completion:nil];
    }

    - (void) imagePickerController: (UIImagePickerController *) picker
                                    didFinishPickingMediaWithInfo: (NSDictionary *) results {
    
        localImage =
            (UIImage *) [results objectForKey:UIImagePickerControllerOriginalImage];
        
        imageView.image = localImage;
        [imageView setNeedsDisplay];
        [[UIApplication sharedApplication] setStatusBarHidden:NO];
        [picker dismissViewControllerAnimated:YES completion:nil];
    }

    - (IBAction) exit:(id)sender{
        [self dismissViewControllerAnimated:YES completion:nil];
    }

@end
